export function Name() { return "fifine GK1"; }
export function VendorId() { return 12610; }
export function ProductId() { return 257; }
export function Size() { return [5, 15]; }
export function Type() { return 'Keyboard'; }
export function Publisher() { return "Feifan"; }
export function Fps() { return 20; }
export function ControllableParameters() {
	return [
		{ "property": "shutdownColor", "group": "lighting", "label": "Shutdown Color", "min": "0", "max": "360", "type": "color", "default": "#009bde" },
		{ "property": "LightingMode", "group": "lighting", "label": "Lighting Mode", "type": "combobox", "values": ["Canvas", "Forced"], "default": "Canvas" },
		{ "property": "forcedColor", "group": "lighting", "label": "Forced Color", "min": "0", "max": "360", "type": "color", "default": "#009bde" },

	];
}

const vLedNames =
	[
		"Esc", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11", "F12",
		"`", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-_", "=+", "Backspace", "Del",
		"Tab", "Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "[", "]", "\\", "Page Up",
		"CapsLock", "A", "S", "D", "F", "G", "H", "J", "K", "L", ";", "'", "Enter", "Page Down",
		"Left Shift", "Z", "X", "C", "V", "B", "N", "M", ",", ".", "/", "Right Shift", "Up Arrow", "End",
		"Left Ctrl", "Left Win", "Left Alt", "Space", "Right Alt", "Fn", "Menu", "Right Ctrl", "Left Arrow", "Down Arrow", "Right Arrow"          //13
	];

const vLedPositions =
	[[0, 0], [0, 1], [0, 2], [0, 3], [0, 4], [0, 5], [0, 6], [0, 7], [0, 8], [0, 9], [0, 10], [0, 11], [0, 12], [0, 13], [0, 14],
	[1, 0], [1, 1], [1, 2], [1, 3], [1, 4], [1, 5], [1, 6], [1, 7], [1, 8], [1, 9], [1, 10], [1, 11], [1, 12], [1, 13], [1, 14],
	[2, 0], [2, 1], [2, 2], [2, 3], [2, 4], [2, 5], [2, 6], [2, 7], [2, 8], [2, 9], [2, 10], [2, 11], [2, 12], [2, 13],
	[3, 0], [3, 1], [3, 2], [3, 3], [3, 4], [3, 5], [3, 6], [3, 7], [3, 8], [3, 9], [3, 10], [3, 11], [3, 12], [3, 13],
	[4, 0], [4, 1], [4, 2], [4, 3], [4, 4], [4, 5], [4, 6], [4, 7], [4, 8], [4, 9], [4, 10], [4, 11], [4, 12], [4, 13]
	];

const vKeymap =
	[
		21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 14,
		42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 99,
		63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 57,
		84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 97, 98, 78,
		105, 106, 107, 111, 115, 116, 117, 119, 120, 121,
	];

export function LedNames() {
	return vLedNames;
}

export function LedPositions() {
	return vLedPositions;
}

export function Initialize() {

}

export function Render() {
	sendcolor();
}
export function Shutdown() {
	// StartPacket();
	sendcolor(true);
	endPacket();
}

function sendcolor(shutdown = false) {
	let packet;
	for (let i = 0; i < vLedPositions.length; i++) {

		const type = {
			0() {
				packet = [ 0xb1, 0x00, 0x00, 0x01];
				for (let o = 4; o < 10; o++) {
					packet[o] = 0;
				}
			},
			15() {
				device.write(packet, 63,4);
				packet = [ 0xb1, 0x00, 0x00, 0x02];
				for (let o = 4; o < 16; o++) {
					packet[o] = 0;
				}
			},
			30() {
				device.write(packet,63,4);
				packet = [ 0xb1, 0x00, 0x00, 0x03];
				for (let o = 4; o < 22; o++) {
					packet[o] = 0;
				}
			},
			42() {
				device.write(packet, 63,4);
				packet = [ 0xb1, 0x00, 0x00, 0x04];
			},
			44() {
				const length = packet.length;
				for (let o = length; o < length + 18; o++) {
					packet[o] = 0;
				}
			},
			45() {
				const length = packet.length;
				packet[length] = 0;
				packet[length + 1] = 0;
				packet[length + 2] = 0;
			},
			54() {
				device.write(packet, 63,4);
				packet = [ 0xb1, 0x00, 0x00, 0x05];
			},
			58() {
				const length = packet.length;
				for (let o = length; o < length + 18; o++) {
					packet[o] = 0;
				}
			},
			65() {
				device.write(packet, 63,4);
				packet = [ 0xb1, 0x00, 0x00, 0x06];
			}

		};
		type[i]?.();


		const color = device.color(vLedPositions[i][0], vLedPositions[i][1]);
		const length = packet.length;
		packet[length] = color[0];
		packet[length + 1] = color[1];
		packet[length + 2] = color[2];
		if (i == 71) device.write(packet, 63,4);
	}

}

function hexToRgb(hex) {
	const result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
	const colors = [];
	colors[0] = parseInt(result[1], 16);
	colors[1] = parseInt(result[2], 16);
	colors[2] = parseInt(result[3], 16);

	return colors;
}

export function Validate() {
	return { type: 0, usage: 0, usagePage: 65280 };
}

export function ImageUrl() {
	return "https://assets.signalrgb.com/devices/brands/hyperx/keyboards/alloy-elite-2.png";
}